// Program File : ltk.cpp
// Greg Lavery	06/29/04
// Updates GE LTK Elite

#include <iostream>
#include <fstream>
#include <string>
#include <iomanip>
#include <conio.h>
using namespace std;

ifstream ltkin;
ofstream ltkout, ltkoutpoint, ltkoutdiff;
string x, fullname, first, last;
int min, sec, time, levcomp, total, namex, playercount;
int levelnum = -1; // used for diff calculator
int leveltime1, leveltime2, tie, levelcount; // all used for points
const int MAXPLAYERS = 100;
const int MAXPOINTS = 35;
int timearray[MAXPLAYERS][4]; // records, levels complete, total time, points
int timearraybest[MAXPLAYERS]; // the array of time, arranged from best to worst
int pointarraybest[MAXPLAYERS]; // the array of points, arranged from best to worst
int levcomplete[MAXPLAYERS]; // list of levels complete, corresponding with player# from 
int WRtime; // user for overall WRtimetimearraybest
int records[MAXPLAYERS]; // list of records, corresponding with player# from pointarraybest
int levdiffcalc[20];
bool newlevel; // variable for new level
string name[MAXPLAYERS]; // firstlastname
string nametimebest[MAXPLAYERS];
string namepointbest[MAXPLAYERS];
string levelnames[20] = {"Dam",
						"Facility",
						"Runway",
						"Surface 1",
						"Bunker 1",
						"Silo",
						"Frigate",
						"Surface 2",
						"Bunker 2",
						"Statue",
						"Archives",
						"Streets",
						"Depot",
						"Train",
						"Jungle",
						"Control",
						"Caverns",
						"Cradle",
						"Aztec",
						"Egypt"};


int convert (string str)
{
	int num=0, digit, ctr, len;

	len = str.length();
	ctr=0;
	while(ctr<len)
	{
		if (str[ctr] > 47  && str[ctr] < 58)
		{
			digit = str[ctr] - 48; // turns ascii code into int (asc("0")=48)
			num = num * 10 + digit;
			ctr++;
		}
		else ctr++;
	}
		
	return num;
}

void initialize ( )
{
	char y;
	string z;
	ifstream ltk1in;
	ofstream ltk1out;

	ltk1in.open("ltk.html");
	ltk1out.open("ltk2.html");

	while (z != "<!$start>")
		ltk1in >> z; // eat up some beginning of the file

	while (y != '$') // convert some more stuff to spaces, for easier reading.
	{
		ltk1in >> y;
		if (y == ':' || y == '/' || y == '<' || y == '>')
			y = ' ';

		ltk1out << y;
	}

}	

int checkName (string thename)
{
	for (namex = 0; namex < MAXPLAYERS; namex++)
	{
		if (thename == name[namex])
			return namex;

		else if (name[namex] == "")
		{
			name[namex] = thename;
			return namex;
		}
	}
}

void goodData(string y)
{
	int xint, xname;

	if (newlevel == true)
	{
		levelcount = 0;
		leveltime2 = 0;
		leveltime1 = 0;
		tie = 0;
	}
	newlevel = false;

	min = convert(y);
	ltkin >> xint;
	sec = xint;
	ltkin >> x;
	fullname = x;
	time = (min * 60) + sec;

	xname = checkName(fullname);
	timearray[xname][1] = timearray[xname][1]++; // (levels completed)++
	timearray[xname][2] = timearray[xname][2] + time; // total = total + time
	levdiffcalc[levelnum]++; // handles percentage of completion per level

	//handles ties
	leveltime1 = leveltime2;
	leveltime2 = time;

	if (leveltime2 == leveltime1)
		tie++;
	else if (tie > 0)
		tie = 0;


	levelcount = levelcount - tie;


	//point calculations

	if (levelcount == 0)
	{
		timearray[xname][3] = timearray[xname][3] + MAXPOINTS;
		timearray[xname][0]++;
		if (tie == 0)
			WRtime += time;
	}
	else if (levelcount == 1)
		timearray[xname][3] = timearray[xname][3] + (MAXPOINTS - 3);
	else if (levelcount < (MAXPOINTS - 3))
		timearray[xname][3] = timearray[xname][3] + (MAXPOINTS - 3 - levelcount);

	levelcount++;
 	levelcount = levelcount + tie;
}

void readIn ( )
{
	while (x != "!$")
	{

		ltkin >> x;

		if (x == "!&")
		{
			newlevel = true;
			levelnum++;
		}

		if (x.substr(0,1) == "0" || x.substr(0,1) == "1") // if the lines start with a 0 or a 1,
			goodData(x);                              // the data isn't garbage
	}
}

void ltkoutbak (int num)
{
	// output the beginning or end of the html stuff
	string x;
	
	if (num == 1)
	{
		ifstream ltkinstart;
		ltkinstart.open("ltktimestart.bak");
		while(ltkinstart)
		{
			ltkinstart >> x;
			ltkout << x << endl;
		}
		ltkinstart.close;
	}
	else if (num == 2)
	{
		ifstream ltkinfinish;
		ltkinfinish.open("ltktimefinish.bak");
		while(ltkinfinish)
		{
			ltkinfinish >> x;
			ltkout << x << endl;
		}
		int WRtimesec = WRtime % 60;
		ltkout << (WRtime - WRtimesec) / 60 << ':' << WRtimesec << endl;
		ltkinfinish.close;
	}

	else if (num == 3)
	{
		ifstream ltkpointinstart;
		ltkpointinstart.open("ltkpointstart.bak");
		while(ltkpointinstart)
		{
			ltkpointinstart >> x;
			ltkoutpoint << x << endl;
		}
		ltkpointinstart.close;
	}
	else if (num == 4)
	{
		ifstream ltkpointoutstart;
		ltkpointoutstart.open("ltkpointfinish.bak");
		while(ltkpointoutstart)
		{
			ltkpointoutstart >> x;
			ltkoutpoint << x << endl;
		}
		ltkpointoutstart.close;
	}

	else if (num == 5)
	{
		ifstream ltkdiffstart;
		ltkdiffstart.open("ltkdiffstart.bak");
		while(ltkdiffstart)
		{
			ltkdiffstart >> x;
			ltkoutdiff << x << endl;
		}
		ltkdiffstart.close;
	}
	else if (num == 6)
	{
		ifstream ltkdifffinish;
		ltkdifffinish.open("ltkdifffinish.bak");
		while(ltkdifffinish)
		{
			ltkdifffinish >> x;
			ltkoutdiff << x << endl;
		}
		ltkdifffinish.close;
	}
	else cout << "whoops...";

}

string nameSpace (string name)
{
	int len = name.length();
	int u = 0, uspace = 0;
	char tempname[40];

	for (int n = 0; n < len; n++)
	{
		if (name[n]>=65 && name[n]<=90)
		{
			tempname[u] = ' ';
			u++;
			uspace++;
			tempname[u] = name[n];
			u++;
		}
		else if (name[n] >= 97 && name[n] <= 122)
		{
			tempname[u] = name[n];
			u++;
		}
		else
		{
			tempname[u] = name[n];
			u++;
		}
	}

	name = "";

	for (u = 0; u < (len + uspace); u++)
		name = name + tempname[u];

	return name;
}

void timeArrange ( )
{
	// do some crazy sorting from best to worst
	int timearraytemp[MAXPLAYERS], timearraytemp2[MAXPLAYERS], levcomptemp[MAXPLAYERS];
	int min = 24000, minx = 0;

	for (int i = 0; i < MAXPLAYERS; i++)
		timearraytemp2[i] = timearray[i][2]; // copy the array over to timearraytemp2


	for (int x = 1; x < MAXPLAYERS; x++)
	{
		for (int i = 0; i < MAXPLAYERS; i++)
		{
			if (timearraytemp2[i] < min)
			{
				min = timearraytemp2[i];
				minx = i;
			}
		}

		timearraytemp[x] = min;   // found the new best time, so assigned
		nametimebest[x] = name[minx]; // the best time (along with the name)
		levcomptemp[x] = timearray[minx][1];

		timearraytemp2[minx] = 24000; // make sure that the old best time
		min = 24000;   // doesn't get compared again
	}

	for (namex = 0; namex < MAXPLAYERS; namex++) // assign the new sorted stuff, back to the old stuff.
	{
		timearraybest[namex] = timearraytemp[namex];
		levcomplete[namex] = levcomptemp[namex];
	}
}


void pointArrange ( )
{
	// do some crazy sorting from best to worst
	int pointarraytemp[MAXPLAYERS], pointarraytemp2[MAXPLAYERS], recordstemp[MAXPLAYERS];
	int max = 0, maxy = 0;

	for (int i = 0; i < MAXPLAYERS; i++)
		pointarraytemp2[i] = timearray[i][3]; // copy the array over to pointarraytemp2


	for (int x = 1; x < MAXPLAYERS; x++)
	{
		for (int i = 0; i < MAXPLAYERS; i++)
		{
			if (pointarraytemp2[i] > max)
			{
				max = pointarraytemp2[i];
				maxy = i;
			}
		}

		pointarraytemp[x] = max;   // found the next most points, so assigned
		namepointbest[x] = name[maxy]; // the best points (along with the name)
		recordstemp[x] = timearray[maxy][0];


		pointarraytemp2[maxy] = -1; // make sure that the old best points
		max = -1;   // doesn't get compared again
	}

	for (namex = 0; namex < MAXPLAYERS; namex++) // assign the new sorted stuff, back to the old stuff.
	{
		pointarraybest[namex] = pointarraytemp[namex];
		records[namex] = recordstemp[namex];

	}
}


void output ( )
{
	string nametemp;

	for (namex = 0; namex < MAXPLAYERS; namex++) // if any levels not completed, add 20 minute penalty
		timearray[namex][2] = timearray[namex][2] + ((20 - timearray[namex][1]) * 1200);

	timeArrange(); // sort them after the penalties

	for (namex = 1; timearraybest[namex] != 24000; namex++)
	{
		playercount++;
		int tothour = 0, totmin = 0, totsec = 0;

		// output time in format "hh:mm:ss"
		while (timearraybest[namex] - 3600 >= 0)
		{
			tothour++;
			timearraybest[namex] -= 3600;
		}
		
		while (timearraybest[namex] - 60 >= 0)
		{
			totmin++;
			timearraybest[namex] -= 60;
		}

		nametemp = nametimebest[namex];

		totsec = timearraybest[namex];
		ltkout << "<tr>" << endl << "     <td>";
		if (namex == 1) { ltkout << "<p class=first>"; }
		else if (levcomplete[namex] == 20) { ltkout << "<p class=special20>"; }
		ltkout << namex << "&nbsp; </td>" << endl;

		ltkout << "     <td>";
		if (namex == 1) { ltkout << "<p class=first>"; }
		else if (levcomplete[namex] == 20) { ltkout << "<p class=special20>"; }
		ltkout << nameSpace(nametemp) << "&nbsp; </td>" << endl;

		ltkout << "     <td>";
		if (namex == 1) { ltkout << "<p class=first>"; }
		else if (levcomplete[namex] == 20) { ltkout << "<p class=special20>"; }
		ltkout << tothour << ":";
		if (totmin < 10)
			ltkout << "0";
		ltkout << totmin << ":";
		if (totsec < 10)
			ltkout << "0";
		ltkout << totsec << "</td>" << endl;

		ltkout << "     <td>";
		if (namex == 1) { ltkout << "<p class=first>"; }
		else if (levcomplete[namex] == 20) { ltkout << "<p class=special20>"; }
		ltkout << levcomplete[namex] << "</td>" << endl;
		ltkout << "</tr>" << endl;
	}
}

void pointout ( )
{
	string nametemp;
	int maxRecords = 0;
	pointArrange();

	for (int r = 0; r <= playercount; r++)
	{
		if (records[r] > maxRecords)
			maxRecords = records[r];
	}


	for (int i = 1; i <= playercount; i++)
	{
		nametemp = namepointbest[i];


		ltkoutpoint << "<tr>" << endl << "     <td>";
		if (i == 1) { ltkoutpoint << "<p class=first>"; }
		else if (records[i] == maxRecords) { ltkoutpoint << "<p class=specialWR>"; }
		ltkoutpoint << i << "&nbsp; </td>" << endl;

		ltkoutpoint << "     <td>";
		if (i == 1) { ltkoutpoint << "<p class=first>"; }
		else if (records[i] == maxRecords) { ltkoutpoint << "<p class=specialWR>"; }
		ltkoutpoint << nameSpace(nametemp) << "&nbsp; </td>" << endl;

		ltkoutpoint << "     <td>";
		if (i == 1) { ltkoutpoint << "<p class=first>"; }
		else if (records[i] == maxRecords) { ltkoutpoint << "<p class=specialWR>"; }
		ltkoutpoint << pointarraybest[i] << "</td>" << endl;

		ltkoutpoint << "     <td>";
		if (i == 1) { ltkoutpoint << "<p class=first>" << records[i]; }
		else if (records[i] == maxRecords) { ltkoutpoint << "<p class=specialWR>" << records[i]; }
		else if (records[i] > 0)
		{
			ltkoutpoint << "<b>";
			ltkoutpoint << records[i];
			ltkoutpoint << "</b>";
		}
		else
			ltkoutpoint << "0";
		ltkoutpoint << "</td>" << endl;
		ltkoutpoint << "</tr>" << endl;
	}
}

void difficultcalc ()
{
	int levtot = 0;

	for (int i = 0; i < 20; i++)
	{
		levtot += levdiffcalc[i];

		ltkoutdiff << "<tr>" << endl;
		ltkoutdiff << "     <td>" << levelnames[i] << "</td>" << endl;
		ltkoutdiff << "     <td>" << 100 - ((levdiffcalc[i] * 100) / playercount) << "</td>" << endl;
		ltkoutdiff << "</tr>" << endl;
	}
	ltkoutdiff << "<tr>" << endl;
	ltkoutdiff << "     <td><b>Total</b></td>" << endl;
	ltkoutdiff << "     <td>" << 100 - ((levtot * 100) / (playercount * 20)) << "</td>" << endl;
	ltkoutdiff << "</tr>" << endl;

}

int main ( )
{
	initialize();

	ltkin.open("ltk2.html");
	ltkout.open("LTKTIME.HTML");
	ltkoutpoint.open("LTKPOINTS.HTML");
	ltkoutdiff.open("LTKDIFF.HTML");

	for (int i = 0; i < MAXPLAYERS; i++)
	{
		for (int j = 0; j < 4; j++)
			timearray[j][i] = 0;
	}
	for (i = 0; i < 20; i++)
		levdiffcalc[i] = 0;

	
	readIn();
	ltkoutbak(1);
	output();
	ltkoutbak(2);
	ltkoutbak(3);
	pointout();
	ltkoutbak(4);
	ltkoutbak(5);
	difficultcalc();
	ltkoutbak(6);

	// wait for user to press a key
	//cout << "Press any key to continue . . .";
	//cout.flush();
	//getch();
	
	return 0;

}
